<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/index', function () {
    return view('index');
});
Route::get('/branc-chart', function () {
    return view('branc-chart');
});
Route::get('/invoice', function () {
    return view('invoice');
});



//Route::post('/transfer','BranchController@transfer')->name('transfer')->middleware('auth');

// import Docs
Route::get('/importDocs','Website\StockController@importDocs')->name('importDocs')->middleware('auth');
Route::get('/accept/{id}','Website\StockController@acceptDoc')->name('acceptDoc')->middleware('auth');

// export Docs
Route::get('/exportDocs','Website\StockController@exportDocs')->name('exportDocs')->middleware('auth');
Route::get('/stock', 'Website\StockController@index')->name('stock')->middleware('auth');
Route::post('/transfer','Website\StockController@transfer')->name('transfer')->middleware('auth');

Route::get('/nots/{id}','Website\StockController@nots')->name('nots')->middleware('auth');

Route::get('/logout', function () {
    Auth::logout();

    return redirect('/login');

});
Route::get('/branches','BranchController@index')->name('branches')->middleware('auth');
Route::post('/addbranch','BranchController@store')->name('addbranch')->middleware('auth');
Route::post('/editbranch','BranchController@update')->name('updatebranch')->middleware('auth');
Route::get('/deletebranch/{id}','BranchController@destroy')->name('deletebranch')->middleware('auth');

Route::get('/users','UserController@index')->name('users')->middleware('auth');
Route::post('/adduser','UserController@store')->name('adduser')->middleware('auth');
Route::post('/edituser','UserController@update')->name('updateuser')->middleware('auth');
Route::get('/deleteuser/{id}','UserController@destroy')->name('deleteuser')->middleware('auth');


//Route::get('/category', function () {
//    return view('category');
//});
//

Auth::routes();

Route::get('/home', 'HomeController@index')->name('home')->middleware('auth');
Route::get('/category', 'Website\RoomTypeController@index')->name('category')->middleware('auth');//get all data of color,maincategory,sub,roomtype
Route::get('/packages', 'Website\PackageController@index')->name('packages')->middleware('auth');

Route::get('/stock2', 'Website\StockController@index')->name('stock2')->middleware('auth');
Route::get('/viewstock', 'Website\StockController@viewstock')->name('viewstock')->middleware('auth');

Route::get('/pending', 'Website\StockController@pending_transfer')->name('pending')->middleware('auth');

Route::get('/requestPackage', 'Website\StockController@requestPackage')->name('requestPackage')->middleware('auth');
Route::post('/stockrequestsubmit', 'Website\StockController@requestPackageSubmit')->name('stockrequestsubmit')->middleware('auth');




Route::post('/createRoomType', 'Website\RoomTypeController@store')->name('createRoomType')->middleware('auth');
Route::post('/createColor', 'Website\ColorController@store')->name('createColor')->middleware('auth');
Route::post('/createMainCategory', 'Website\MainCategoryController@store')->name('createMainCategory')->middleware('auth');
Route::post('/createSubCategory', 'Website\SubCategoryController@store')->name('createSubCategory')->middleware('auth');



Route::get('/home', 'HomeController@index')->name('home')->middleware('auth');


Route::get('/orderview', 'OrderController@orderview')->name('orderview')->middleware('auth');
Route::post('/create_order', 'OrderController@orderCreate')->name('create_order')->middleware('auth');

Route::get('/retrivedorderview', 'OrderController@retrivedorderview')->name('retrivedorderview')->middleware('auth');
Route::post('/retrive_order/{order_number}', 'OrderController@retrivedorder')->name('retrivedorder')->middleware('auth');
Route::get('/getitemStockBySerial', 'OrderController@getItemStockBySerial')->name('getitemStockBySerial')->middleware('auth');
//barcode
Route::get('/barcode','BarcodegeneratorController@barcode');

