<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Branches;
// use APP\Models\Branches;
use App\Models\Governs;
use App\Models\Stock;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use phpDocumentor\Reflection\DocBlock\Tags\Reference\Url;
use Validator;

class BranchController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $AllBranches=Branches::with('stock.products')->get();
//         return $stock=Stock::with('products')->get();
//        dd($AllBranches[87]);
         $governs= Governs::all();
         return view('branches',compact('AllBranches','governs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
//        dd($request);
        $validator = Validator::make($request->input(), [

            'title' => ['required', 'string', 'max:255'],
            'address' => ['required', 'string', 'max:255'],
            // 'title_en' => ['required', 'string', 'max:255'],
            // 'sub_title_en' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:11'],
            //  'image' => 'required', //|base64image
            //  'location' => ['required', 'string', 'max:255'],
//            'stock' => ['required', 'max:11'],
            'govern_id' => 'required', //id

        ]);
//        dd($validator);
        if ($validator->fails()) {

            $message="error in validation";


            } else {
                    $newBranch=new Branches;
                    $newBranch->title= $request->title;
                    $newBranch->sub_title= $request->address;
                    // $newBranch->title_en= $request->title_en;
                    // $newBranch->sub_title_en= $request->sub_title_en;
                    $newBranch->phone= $request->phone;
                    // $newBranch->location= $request->location;
                    // $branch_picture = $this->saveImageBase64($request->image);
                    // $newBranch->photo=  $url. "/branches_images/" .$branch_picture;
                    //check governs
                    $govern=Governs::where('id',$request->govern_id)->first();
                    if($govern)
                    {
                     $newBranch->govern_id= $govern->id;
                    }
                    else
                    {
                         $message="govern not exist";
                    }
                     $newBranch->save();

                    if($newBranch){
                     $message="created branch successfly";
                    }else{
                     $message="error in create branch";
                    }

            }
 return redirect()->route('branches')->with($message);

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    public function transfer(Request $request)
    {

        return Auth::user()->getuserbranchid();
        $branch=Session::get(userbranchid);
        dd($branch);
        foreach ($request->title as $key=>$value){
            dd($value);
        }

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id=0)
    {
//        dd($request);
        $validator = Validator::make($request->input(), [

            'title' => ['required', 'string', 'max:255'],
            'address' => ['required', 'string', 'max:255'],
            // 'title_en' => ['required', 'string', 'max:255'],
            // 'sub_title_en' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:11'],
            //  'image' => 'required', //|base64image
            //  'location' => ['required', 'string', 'max:255'],
//            'stock' => ['required', 'max:11'],
//            'govern_id' => 'required', //id

        ]);
//        dd($validator);
        if ($validator->fails()) {

            $message="error in validation";


        } else {
            $newBranch=Branches::where('id',$request->id)->first();
            $newBranch->title= $request->title;
            $newBranch->sub_title= $request->address;
            // $newBranch->title_en= $request->title_en;
            // $newBranch->sub_title_en= $request->sub_title_en;
            $newBranch->phone= $request->phone;
            // $newBranch->location= $request->location;
            // $branch_picture = $this->saveImageBase64($request->image);
            // $newBranch->photo=  $url. "/branches_images/" .$branch_picture;
            //check governs
//            $govern=Governs::where('id',$request->govern_id)->first();
//            if($govern)
//            {
//                $newBranch->govern_id= $govern->id;
//            }
//            else
//            {
//                $message="govern not exist";
//            }
            $newBranch->save();

            if($newBranch){
                $message="created branch successfly";
            }else{
                $message="error in create branch";
            }

        }
        return redirect()->route('branches')->with($message);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $branch=Branches::where('id',$id)->first();
        $branch->delete();
        if($branch){
            $message="delete branch successfly";
            }else{
            $message="error in delete branch";
            }

        return redirect()->route('branches')->with($message);

    }


      /**
     * Get a validator for an incoming registration request.
     *
     * @param array $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {

            $validator = Validator::make($data, [
                'title' => ['required', 'string', 'max:255'],
                'address' => ['required', 'string', 'max:255'],
                // 'title_en' => ['required', 'string', 'max:255'],
                // 'sub_title_en' => ['required', 'string', 'max:255'],
                'phone' => ['required', 'string', 'max:11'],
                //  'image' => 'required', //|base64image
                //  'location' => ['required', 'string', 'max:255'],
//                'stock' => ['required', 'integer', 'max:11'],
                  'govern_id' => 'required|integer', //id

            ]);

        return $validator;

    }


        protected function saveImageBase64($request_image)
    {
        $path = public_path('branches_images');
        if (!File::isDirectory($path)) {
            File::makeDirectory($path, 0777, true, true);
        }

        $file_data = substr($request_image, strpos($request_image, ",") + 1);

        //generating unique file name;
        $file_name = 'image_' . str_random(5) . '.png';

        $image = base64_decode($file_data);
        $path = public_path() . "/branches_images/" . $file_name;
        file_put_contents($path, $image);
        return $file_name;
    }
}
